<x-app-layout>
    <x-slot name="header">
        {{ __('Address') }}
    </x-slot>

    <div class="row" id="user-profile">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('profile.address', $user->id) }}" method="post">
                        @csrf @method('PUT')
                        <div class="row mb-4">
                            <div class="col-lg-12">
                                <label class="form-label" for="address">Address *:</label>
                                <input type="text" class="form-control @error('address') is-invalid @enderror"
                                    name="address" value="{{ old('address', $address->address) }}" placeholder="Main Address">
                                @error('address')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-6">
                                <label class="form-label" for="address_one">Address Line 1:</label>
                                <input type="text" class="form-control @error('address_one') is-invalid @enderror"
                                    name="address_one" value="{{ old('address_one', $address->address_one) }}" placeholder="Address Line 1">
                                @error('address_one')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-lg-6">
                                <label class="form-label" for="address_two">Address Line 2:</label>
                                <input type="text" class="form-control @error('address_two') is-invalid @enderror"
                                    name="address_two" value="{{ old('address_two', $address->address_two) }}" placeholder="Address Line 2">
                                @error('address_two')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-4">

                        <x-location-picker
                            :selected-country="$address->country ?? null"
                            :selected-state="$address->state ?? null"
                            :selected-city="$address->city ?? null"
                        />
                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-6">
                                <label class="form-label" for="postal">Postal Code *:</label>
                                <input type="text" class="form-control @error('postal') is-invalid @enderror"
                                    name="postal" value="{{ old('postal', $address->postal) }}" placeholder="Postal Code">
                                @error('postal')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-lg-6">
                                <label class="form-label" for="landmark">Landmark:</label>
                                <input type="text" class="form-control @error('landmark') is-invalid @enderror"
                                    name="landmark" value="{{ old('landmark', $address->landmark) }}" placeholder="Landmark">
                                @error('landmark')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-6">
                                <label class="form-label" for="latitude">Latitude:</label>
                                <input type="number" step="any" class="form-control @error('latitude') is-invalid @enderror"
                                    name="latitude" value="{{ old('latitude', $address->latitude) }}" placeholder="Latitude">
                                @error('latitude')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-lg-6">
                                <label class="form-label" for="longitude">Longitude:</label>
                                <input type="number" step="any" class="form-control @error('longitude') is-invalid @enderror"
                                    name="longitude" value="{{ old('longitude', $address->longitude) }}" placeholder="Longitude">
                                @error('longitude')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-12">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input @error('is_default') is-invalid @enderror"
                                        name="is_default" value="1" {{ old('is_default', $address->is_default) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_default">Set as Default Address</label>
                                    @error('is_default')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Save Address</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
